/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.metadata.ConfigurationHolder;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.metadata.property.ExcelReadHeadProperty;
import com.alibaba.excel.util.ConverterUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.esay.SimpleCellWriteHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtils {
    public static <T> void writeExcel2Stream(HttpServletResponse response, Class<T> aClass, List<T> datas, String filename, String sheetname) throws IOException {
        ExcelWriterBuilder builder = ExcelUtils.buildDownloadForHttpResponse((HttpServletResponse)response, (String)filename, (boolean)true, null);
        ExcelWriter writer = builder.build();
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/octet-stream");
        ExcelUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
        writer.write(datas, ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)sheetname).head(aClass)).build());
        writer.finish();
    }

    public static String percentEncode(String s) throws UnsupportedEncodingException {
        String encode = URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        return encode.replaceAll("\\+", "%20");
    }

    public static void setAttachmentResponseHeader(HttpServletResponse response, String realFileName) throws UnsupportedEncodingException {
        String percentEncodedFileName = ExcelUtils.percentEncode((String)realFileName);
        StringBuilder contentDispositionValue = new StringBuilder();
        contentDispositionValue.append("attachment; filename=").append(percentEncodedFileName).append(";").append("filename*=").append("utf-8''").append(percentEncodedFileName);
        response.setHeader("Content-disposition", contentDispositionValue.toString());
    }

    public static ExcelWriterBuilder buildDownloadForHttpResponse(HttpServletResponse response, String fileName, boolean flag, List<WriteHandler> writeHandlerList) throws IOException {
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)response.getOutputStream());
        writeHandlerList = Optional.ofNullable(writeHandlerList).orElse(new ArrayList());
        writeHandlerList.forEach(arg_0 -> ((ExcelWriterBuilder)write).registerWriteHandler(arg_0));
        ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).needHead(Boolean.valueOf(true));
        if (flag) {
            write.registerWriteHandler((WriteHandler)new SimpleCellWriteHandler());
        }
        return write;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> byte[] exportToByteArray(List<T> dataList, Class<T> clazz, String sheetName) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, clazz).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)new SimpleCellWriteHandler())).sheet(sheetName).doWrite(dataList);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5931\u8d25", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] exportToCsv(String[] headers, List<String[]> dataList) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            StringBuilder csvContent = new StringBuilder();
            if (headers != null && headers.length > 0) {
                csvContent.append(String.join((CharSequence)",", headers)).append("\n");
            }
            for (CharSequence[] charSequenceArray : dataList) {
                csvContent.append(String.join((CharSequence)",", charSequenceArray)).append("\n");
            }
            outputStream.write(csvContent.toString().getBytes(StandardCharsets.UTF_8));
            Object object = outputStream.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faCSV\u5931\u8d25", e);
        }
    }

    public static void setCsvResponseHeader(HttpServletResponse response, String fileName) {
        try {
            response.setContentType("text/csv;charset=utf-8");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            ExcelUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)(fileName.endsWith(".csv") ? fileName : fileName + ".csv"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u8bbe\u7f6eCSV\u54cd\u5e94\u5934\u5931\u8d25", e);
        }
    }

    public static void buildUpdateHeadAgain(AnalysisContext analysisContext, Map<Integer, ReadCellData<?>> headMap, Class clazz) {
        ExcelReadHeadProperty excelHeadPropertyData = analysisContext.readSheetHolder().excelReadHeadProperty();
        Map nowHeadMapData = excelHeadPropertyData.getHeadMap();
        if (MapUtils.isNotEmpty((Map)nowHeadMapData)) {
            return;
        }
        ExcelReadHeadProperty originExcelHeadPropertyData = new ExcelReadHeadProperty((ConfigurationHolder)analysisContext.currentReadHolder(), clazz, null);
        Map originHeadMapData = originExcelHeadPropertyData.getHeadMap();
        Map dataMap = ConverterUtils.convertToStringMap(headMap, (AnalysisContext)analysisContext);
        HashMap<Integer, Head> tmpHeadMap = new HashMap<Integer, Head>(originHeadMapData.size() * 4 / 3 + 1);
        HashMap tmpContentPropertyMap = new HashMap(originHeadMapData.size() * 4 / 3 + 1);
        block0: for (Map.Entry entry : originHeadMapData.entrySet()) {
            Head headData = (Head)entry.getValue();
            String headName = String.format("%s.%s", headData.getField().getDeclaringClass().getSimpleName(), headData.getFieldName());
            ExcelProperty annotation = headData.getField().getAnnotation(ExcelProperty.class);
            String[] value = annotation.value();
            if (value.length > 0) {
                headName = MessageUtils.getMessage((String)value[0], (Object[])new Object[0]);
            }
            for (Map.Entry stringEntry : dataMap.entrySet()) {
                if (stringEntry == null) continue;
                String headString = ((String)stringEntry.getValue()).trim();
                Integer stringKey = (Integer)stringEntry.getKey();
                if (StringUtils.isEmpty((CharSequence)headString) || !StringUtils.equals((CharSequence)headName, (CharSequence)headString)) continue;
                headData.setColumnIndex(stringKey);
                tmpHeadMap.put(stringKey, headData);
                continue block0;
            }
        }
        excelHeadPropertyData.setHeadMap(tmpHeadMap);
    }
}

