/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.exception;

import com.bms.common.exception.RRException;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.R;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class RRExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={RRException.class})
    public R handleRRException(RRException e) {
        R r = new R();
        r.put("code", (Object)e.getCode());
        r.put("msg", (Object)e.getMessage());
        return r;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public R handlerNoFoundException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((int)404, (String)MessageUtils.getMessage((String)"common.no.path", (Object[])new Object[0]));
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public R handleDuplicateKeyException(DuplicateKeyException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((String)MessageUtils.getMessage((String)"common.data.exist", (Object[])new Object[0]));
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public R handleAuthorizationException(AuthorizationException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((String)MessageUtils.getMessage((String)"common.no.permission", (Object[])new Object[0]));
    }

    @ExceptionHandler(value={Exception.class})
    public R handleException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error();
    }
}

