/*
 * Decompiled with CFR 0.152.
 */
package com.bms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.enums.RedisKeyEnum;
import com.bms.common.utils.FtpUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.Query;
import com.bms.common.utils.RedisUtils;
import com.bms.entity.Tenant;
import com.bms.mapper.TenantMapper;
import com.bms.service.BillService;
import com.bms.service.CgRatesService;
import com.bms.service.TenantService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantServiceImpl
extends ServiceImpl<TenantMapper, Tenant>
implements TenantService {
    @Autowired
    BillService billService;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    CgRatesService cgRatesService;

    public List<Tenant> filePushList() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Tenant::getType, (Object)1)).eq(Tenant::getEnable, (Object)true)).list();
    }

    public PageUtils queryPage(Map<String, Object> params) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Object tenant = params.get("tenant");
        if (tenant != null) {
            wrapper.like(StringUtils.isNotBlank((String)tenant.toString()), Tenant::getTenant, tenant);
        }
        IPage page = this.page(new Query().getPage(params), (Wrapper)wrapper);
        page.getRecords().forEach(item -> {
            item.setBillDealPercentage(this.billService.billDealPercentage(item.getTenant()));
            if (item.getEnable().booleanValue()) {
                if (item.getType().equals("0")) {
                    boolean hasKey = this.redisUtils.hasKey(RedisKeyEnum.PBX_STATUS.getKey() + item.getTenant());
                    item.setStatus(Boolean.valueOf(hasKey));
                } else if (item.getType().equals("1")) {
                    FtpUtils.FtpConfig ftpConfig = new FtpUtils.FtpConfig();
                    ftpConfig.setProtocol(item.getProtocol());
                    ftpConfig.setHost(item.getHost());
                    ftpConfig.setPort(item.getPort().intValue());
                    ftpConfig.setUsername(item.getUsername());
                    ftpConfig.setPassword(item.getPassword());
                    ftpConfig.setRemotePath(item.getPath());
                    boolean connection = FtpUtils.testConnection((FtpUtils.FtpConfig)ftpConfig);
                    item.setStatus(Boolean.valueOf(connection));
                }
            }
        });
        return new PageUtils(page);
    }

    public Tenant getOneByTenant(String tenant) {
        return (Tenant)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Tenant::getTenant, (Object)tenant)).eq(Tenant::getEnable, (Object)true)).eq(Tenant::getType, (Object)"0")).one();
    }

    public void removeBatch(List<Long> ids) {
        for (Long id : ids) {
            Tenant tenant = (Tenant)this.getById((Serializable)id);
            if (tenant == null) continue;
            this.cgRatesService.removeCgInitConfig(tenant.getTenant());
        }
        this.removeByIds(ids);
    }
}

