/*
 * Decompiled with CFR 0.152.
 */
package com.bms.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.bms.common.model.BackupSettingVo;
import com.bms.modules.job.entity.ScheduleJobEntity;
import com.bms.modules.job.service.ScheduleJobService;
import com.bms.modules.sys.entity.SysBackupRecord;
import com.bms.modules.sys.service.SysBackupRecordService;
import com.bms.service.CgRatesService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysBackupService {
    private static final Logger log = LoggerFactory.getLogger(SysBackupService.class);
    private static final String BACKUP_PATH = "/bms/backup";
    private static final String BACKUP_FILE_PREFIX = "backup_";
    private static final String BACKUP_FILE_SUFFIX = ".sql";
    private static final String BACKUP_TABLE = " schedule_job session_costs sys_config sys_menu sys_role sys_role_menu sys_user   sys_user_role tb_bill tb_file_record tb_tenant tp_account_actions tp_action_plans   tp_action_triggers tp_actions tp_attributes tp_chargers tp_destination_rates tp_destinations   tp_filters tp_ips tp_rating_plans tp_rating_profiles tp_resources versions   tp_rates tp_routes tp_shared_groups tp_stats tp_thresholds tp_timings tp_trends tp_rankings ";
    @Value(value="${spring.datasource.druid.username}")
    private String username;
    @Value(value="${spring.datasource.druid.password}")
    private String password;
    private static final String DATABASE = "cgrates";
    @Autowired
    private SysBackupRecordService backupRecordService;
    @Autowired
    private ScheduleJobService jobService;
    @Autowired
    private CgRatesService cgRatesService;

    public void executeBackup(String backupType, String description) {
        String backupPath;
        block16: {
            new File(BACKUP_PATH).mkdirs();
            backupPath = "/bms/backup/backup_" + System.currentTimeMillis() + BACKUP_FILE_SUFFIX;
            String backupCmd = "mysqldump -u" + this.username + " -p" + this.password + " " + DATABASE + BACKUP_TABLE + " > " + backupPath;
            log.info("backup cmd: {}", (Object)backupCmd);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("bash", "-c", backupCmd);
            try {
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) break block16;
                StringBuilder errorMsg = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        errorMsg.append(line).append("\n");
                    }
                }
                log.error("\u5907\u4efd\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)exitCode, (Object)errorMsg);
                throw new RuntimeException("backup command failed with exit code: " + exitCode + ", error: " + errorMsg);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("backup failed", e);
            }
        }
        File file = new File(backupPath);
        if (!file.exists()) {
            throw new RuntimeException("backup failed, backup file not found");
        }
        SysBackupRecord backupRecord = new SysBackupRecord();
        backupRecord.setBackupType(backupType);
        backupRecord.setFilePath(backupPath);
        backupRecord.setFileSize(Long.valueOf(file.length()));
        backupRecord.setStatus("SUCCESS");
        backupRecord.setDescription(description);
        backupRecord.setCreateTime(Date.from(Instant.now()));
        this.backupRecordService.save((Object)backupRecord);
    }

    public void recoverBackup(Long id) {
        SysBackupRecord backupRecord = (SysBackupRecord)this.backupRecordService.getById((Serializable)id);
        if (backupRecord == null) {
            throw new RuntimeException("backup record not found");
        }
        String backupPath = backupRecord.getFilePath();
        if (StringUtils.isBlank((CharSequence)backupPath)) {
            throw new RuntimeException("backup file not found");
        }
        File file = new File(backupPath);
        if (!file.exists()) {
            throw new RuntimeException("backup file not found");
        }
        String recoverCmd = "mysql -u" + this.username + " -p" + this.password + " " + DATABASE + " < " + backupPath;
        log.info("recover cmd: {}", (Object)recoverCmd);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("bash", "-c", recoverCmd);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                StringBuilder errorMsg = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        errorMsg.append(line).append("\n");
                    }
                }
                log.error("\u5907\u4efd\u6062\u590d\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)exitCode, (Object)errorMsg);
                throw new RuntimeException("recover command failed with exit code: " + exitCode + ", error: " + errorMsg);
            }
            this.cgRatesService.loadTariffPlanFromStorDb();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("recover failed", e);
        }
    }

    public BackupSettingVo getBackupSetting() {
        BackupSettingVo backupSettingVo = new BackupSettingVo();
        ScheduleJobEntity backupTask = (ScheduleJobEntity)((LambdaQueryChainWrapper)this.jobService.lambdaQuery().eq(ScheduleJobEntity::getBeanName, (Object)backupSettingVo.getBeanName())).one();
        if (backupTask != null) {
            backupSettingVo.setEnabled(Boolean.valueOf(backupTask.getStatus() == 0));
            backupSettingVo.setCronExpression(backupTask.getCronExpression());
        }
        return backupSettingVo;
    }

    public void saveBackupSetting(BackupSettingVo backupSettingVo) {
        ScheduleJobEntity backupTask = (ScheduleJobEntity)((LambdaQueryChainWrapper)this.jobService.lambdaQuery().eq(ScheduleJobEntity::getBeanName, (Object)backupSettingVo.getBeanName())).one();
        boolean isUpdate = true;
        if (backupTask == null) {
            backupTask = new ScheduleJobEntity();
            backupTask.setBeanName(backupSettingVo.getBeanName());
            isUpdate = false;
        }
        backupTask.setCronExpression(backupSettingVo.getCronExpression());
        backupTask.setStatus(Integer.valueOf(backupSettingVo.getEnabled() != false ? 0 : 1));
        if (isUpdate) {
            this.jobService.update(backupTask);
        } else {
            this.jobService.saveJob(backupTask);
        }
    }
}

