/*
 * Decompiled with CFR 0.152.
 */
package com.bms.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bms.common.enums.RedisKeyEnum;
import com.bms.common.model.AccountVo;
import com.bms.common.model.CgResult;
import com.bms.common.utils.DateUtils;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.RedisUtils;
import com.bms.entity.Tenant;
import com.bms.entity.TpAccountAction;
import com.bms.service.CgRatesService;
import com.bms.service.TpAccountActionService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CgRatesService {
    private static final Logger log = LoggerFactory.getLogger(CgRatesService.class);
    @Value(value="${cgRates.url}")
    private String cgRatesUrl;
    @Value(value="${cgRates.username}")
    private String username;
    @Value(value="${cgRates.password}")
    private String password;
    private static final String DEFAULT_TP_ID = "default";
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private ObjectMapper objectMapper;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TpAccountActionService accountActionService;
    @Autowired
    private RedisTemplate<String, Object> cgratesRedisTemplate;

    public <T> T callCgRatesApi(String method, Object params, Class<T> responseType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addBasicAuth(headers);
        Map requestMap = this.buildJsonRpcRequest(method, params);
        HttpEntity entity = new HttpEntity((Object)requestMap, (MultiValueMap)headers);
        return (T)this.restTemplate.postForObject(this.cgRatesUrl, (Object)entity, responseType, new Object[0]);
    }

    public <T> CgResult<T> callCgRatesApiWithResult(String method, Object params, Class<T> resultType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addBasicAuth(headers);
        Map requestMap = this.buildJsonRpcRequest(method, params);
        HttpEntity entity = new HttpEntity((Object)requestMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.cgRatesUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        try {
            1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
            CgResult rawResult = (CgResult)this.objectMapper.readValue((String)response.getBody(), (TypeReference)typeRef);
            CgResult typedResult = new CgResult();
            typedResult.setId(rawResult.getId());
            typedResult.setError(rawResult.getError());
            if (rawResult.getResult() != null) {
                Object convertedResult = this.objectMapper.convertValue(rawResult.getResult(), resultType);
                typedResult.setResult(convertedResult);
            }
            return typedResult;
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790 CGRates \u54cd\u5e94\u5931\u8d25", e);
        }
    }

    public <T> T callCgRatesApiForResult(String method, Object params, Class<T> resultType) {
        CgResult cgResult = this.callCgRatesApiWithResult(method, params, resultType);
        if (cgResult.getError() != null && !cgResult.getError().isEmpty()) {
            throw new RuntimeException("Call CGRates API Failed: " + cgResult.getError());
        }
        return (T)cgResult.getResult();
    }

    public <T> CgResult<T> callCgRatesApiWithTypeReference(String method, Object params, TypeReference<CgResult<T>> typeReference) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addBasicAuth(headers);
        Map requestMap = this.buildJsonRpcRequest(method, params);
        HttpEntity entity = new HttpEntity((Object)requestMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.cgRatesUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        try {
            return (CgResult)this.objectMapper.readValue((String)response.getBody(), typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790 CGRates \u54cd\u5e94\u5931\u8d25", e);
        }
    }

    private Map<String, Object> buildJsonRpcRequest(String method, Object params) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("id", System.currentTimeMillis());
        requestMap.put("jsonrpc", "2.0");
        requestMap.put("method", method);
        requestMap.put("params", params);
        return requestMap;
    }

    private void addBasicAuth(HttpHeaders headers) {
        if (this.username != null && !this.username.isEmpty() && this.password != null) {
            String auth = this.username + ":" + this.password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + new String(encodedAuth);
            headers.set("Authorization", authHeader);
        }
    }

    public void deleteAccountByTenant(String tenant) {
        List accountIds = this.getAccountIdsByTenant(tenant, null);
        accountIds.forEach(accountId -> {
            HashMap<String, String> removeAccountParam = new HashMap<String, String>();
            removeAccountParam.put("Tenant", tenant);
            removeAccountParam.put("Account", (String)accountId);
            this.callCgRatesApiWithResult("ApierV2.RemoveAccount", (Object)new Object[]{removeAccountParam}, Object.class);
        });
    }

    public void deleteAccountByTenant(String tenant, List<String> accountIds) {
        accountIds.forEach(accountId -> {
            HashMap<String, String> removeAccountParam = new HashMap<String, String>();
            removeAccountParam.put("Tenant", tenant);
            removeAccountParam.put("Account", (String)accountId);
            this.callCgRatesApiWithResult("ApierV2.RemoveAccount", (Object)new Object[]{removeAccountParam}, Object.class);
        });
    }

    public List<String> getAccountIdsByTenant(String tenant, String keyword) {
        String prefix = "acc_" + tenant + ":";
        Set keys = this.cgratesRedisTemplate.keys((Object)(prefix + "*" + (StringUtils.isBlank((CharSequence)keyword) ? "" : keyword + "*")));
        return keys.stream().map(key -> key.replace(prefix, "")).collect(Collectors.toList());
    }

    public void saveCgRatesUser(Set<String> numberSet, Tenant tenant) {
        String type = tenant.getType();
        boolean noAccount = numberSet == null || numberSet.isEmpty();
        List existAccountIds = this.getAccountIdsByTenant(tenant.getTenant(), null);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            if (noAccount) {
                return;
            }
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"0")) {
            if (noAccount) {
                if (tenant.getAutoDelete().booleanValue()) {
                    this.accountActionService.remove((Wrapper)new LambdaQueryWrapper().eq(TpAccountAction::getTenant, (Object)tenant.getTenant()));
                    this.deleteAccountByTenant(tenant.getTenant());
                }
                return;
            }
            if (tenant.getAutoDelete().booleanValue()) {
                List needDeleteIds = existAccountIds.stream().filter(accountId -> !numberSet.contains(accountId)).collect(Collectors.toList());
                this.deleteAccountByTenant(tenant.getTenant(), needDeleteIds);
            }
        }
        assert (numberSet != null);
        List accountActions = numberSet.stream().map(number -> new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        boolean saved = this.accountActionService.saveTpAccountActionBatch(accountActions);
        if (saved) {
            3 loadAccountActionsMap = new /* Unavailable Anonymous Inner Class!! */;
            CgResult loadAccountActionsResult = this.callCgRatesApiWithResult("APIerSv1.LoadAccountActions", (Object)new Object[]{loadAccountActionsMap}, String.class);
            log.info("{} LoadAccountActions result - {}", (Object)tenant.getTenant(), (Object)loadAccountActionsResult);
        }
    }

    public void initCgConfig(String tenant) {
        HashMap<String, Object> createParams = new HashMap<String, Object>();
        createParams.put("TPid", DEFAULT_TP_ID);
        createParams.put("Tenant", tenant);
        createParams.put("ID", "DEFAULT");
        createParams.put("FilterIDs", null);
        createParams.put("ActivationInterval", null);
        createParams.put("RunID", "*default");
        createParams.put("AttributeIDs", new String[0]);
        createParams.put("Weight", 10);
        createParams.put("APIOpts", new HashMap());
        String result = (String)this.callCgRatesApi("ApierV1.SetTPCharger", (Object)new Object[]{createParams}, String.class);
        log.info("{} SetTPCharger result - {}", (Object)tenant, (Object)result);
        HashMap<String, Object> resourceParams = new HashMap<String, Object>();
        resourceParams.put("TPid", DEFAULT_TP_ID);
        resourceParams.put("ID", "RES_DEFAULT");
        resourceParams.put("Tenant", tenant);
        resourceParams.put("FilterIDs", new ArrayList());
        resourceParams.put("ActivationInterval", null);
        resourceParams.put("UsageTTL", "-1");
        resourceParams.put("Limit", "999999");
        resourceParams.put("AllocationMessage", "");
        resourceParams.put("Blocker", false);
        resourceParams.put("Stored", false);
        resourceParams.put("Weight", 10);
        resourceParams.put("ThresholdIDs", new ArrayList());
        String setResourceProfileResult = (String)this.callCgRatesApi("APIerSv1.SetTPResource", (Object)new Object[]{resourceParams}, String.class);
        log.info("{} SetTPResource result - {}", (Object)tenant, (Object)setResourceProfileResult);
        HashMap<String, Object> routeProfileParams = new HashMap<String, Object>();
        routeProfileParams.put("Tenant", tenant);
        routeProfileParams.put("TPid", DEFAULT_TP_ID);
        routeProfileParams.put("ID", "ROUTE_PROFILE_DEFAULT");
        routeProfileParams.put("FilterIDs", new ArrayList());
        routeProfileParams.put("ActivationInterval", null);
        routeProfileParams.put("Sorting", "*weight");
        routeProfileParams.put("SortingParameters", null);
        4 route = new /* Unavailable Anonymous Inner Class!! */;
        routeProfileParams.put("Routes", Collections.singletonList(route));
        routeProfileParams.put("Weight", 10);
        String SetRouteProfileResult = (String)this.callCgRatesApi("APIerSv1.SetTPRouteProfile", (Object)new Object[]{routeProfileParams}, String.class);
        log.info("{} SetTPRouteProfile result - {}", (Object)tenant, (Object)SetRouteProfileResult);
    }

    public void removeCgInitConfig(String tenant) {
        String RemoveTPChargerResult = (String)this.callCgRatesApi("APIerSv1.RemoveTPCharger", (Object)new Object[]{new /* Unavailable Anonymous Inner Class!! */}, String.class);
        log.info("{} RemoveTPCharger result - {}", (Object)tenant, (Object)RemoveTPChargerResult);
        String RemoveTPResourceResult = (String)this.callCgRatesApi("APIerSv1.RemoveTPResource", (Object)new Object[]{new /* Unavailable Anonymous Inner Class!! */}, String.class);
        log.info("{} RemoveTPResource result - {}", (Object)tenant, (Object)RemoveTPResourceResult);
        String RemoveTPRouteProfileResult = (String)this.callCgRatesApi("APIerSv1.RemoveTPRouteProfile", (Object)new Object[]{new /* Unavailable Anonymous Inner Class!! */}, String.class);
        log.info("{} RemoveTPRouteProfile result - {}", (Object)tenant, (Object)RemoveTPRouteProfileResult);
    }

    public Map<String, Object> getAccountStats() {
        try {
            Object[] params = new Object[]{new HashMap()};
            Map result = (Map)this.callCgRatesApi("ApierV1.GetAccountsCount", (Object)params, Map.class);
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("total", result.getOrDefault("result", 0));
            return stats;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8d26\u6237\u7edf\u8ba1\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("total", 0);
            return stats;
        }
    }

    public Map<String, Object> getActiveSessions() {
        try {
            HashMap<String, Object> sessions = new HashMap<String, Object>();
            Set keys = this.redisUtils.keys(RedisKeyEnum.ACTIVE_SESSION.getKey() + "*");
            sessions.put("count", keys == null ? 0 : keys.size());
            return sessions;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d3b\u8dc3\u4f1a\u8bdd\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> sessions = new HashMap<String, Object>();
            sessions.put("count", 0);
            return sessions;
        }
    }

    public Map<String, Object> getTodayRevenue() {
        HashMap<String, Object> revenue = new HashMap<String, Object>();
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("AnswerTimeStart", DateUtils.getZonedDateTimeFormat((LocalDateTime)LocalDate.now().atStartOfDay()));
            queryParams.put("AnswerTimeEnd", DateUtils.getZonedDateTimeFormat((LocalDateTime)LocalDate.now().plusDays(1L).atStartOfDay()));
            Object[] params = new Object[]{queryParams};
            Map result = (Map)this.callCgRatesApi("CDRsV1.GetCDRs", (Object)params, Map.class);
            double totalRevenue = 0.0;
            List cdrs = (List)result.get("result");
            if (CollectionUtils.isNotEmpty((Collection)cdrs)) {
                for (Map cdr : cdrs) {
                    Object cost = cdr.get("Cost");
                    if (cost == null) continue;
                    double parsedDouble = Double.parseDouble(cost.toString());
                    totalRevenue += parsedDouble > 0.0 ? parsedDouble : 0.0;
                }
            }
            revenue.put("amount", String.format("%.2f", totalRevenue));
            return revenue;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4eca\u65e5\u6536\u5165\u5931\u8d25", (Throwable)e);
            revenue.put("amount", "0.00");
            return revenue;
        }
    }

    public Map<String, Object> getTotalRevenue() {
        HashMap<String, Object> revenue = new HashMap<String, Object>();
        try {
            HashMap queryParams = new HashMap();
            Object[] params = new Object[]{queryParams};
            Map result = (Map)this.callCgRatesApi("CDRsV1.GetCDRs", (Object)params, Map.class);
            double totalRevenue = 0.0;
            List cdrs = (List)result.get("result");
            if (CollectionUtils.isNotEmpty((Collection)cdrs)) {
                for (Map cdr : cdrs) {
                    Object cost = cdr.get("Cost");
                    if (cost == null) continue;
                    double parsedDouble = Double.parseDouble(cost.toString());
                    totalRevenue += parsedDouble > 0.0 ? parsedDouble : 0.0;
                }
            }
            revenue.put("amount", String.format("%.2f", totalRevenue));
            return revenue;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4eca\u65e5\u6536\u5165\u5931\u8d25", (Throwable)e);
            revenue.put("amount", "0.00");
            return revenue;
        }
    }

    public Map<String, Object> getSystemStatus() {
        try {
            Object[] params = new Object[]{new HashMap()};
            Map result = (Map)this.callCgRatesApi("CoreSv1.Status", (Object)params, Map.class);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("status", "OK");
            status.put("version", result.getOrDefault("Version", "Unknown"));
            status.put("uptime", result.getOrDefault("Uptime", "Unknown"));
            return status;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u72b6\u6001\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("status", "ERROR");
            status.put("error", e.getMessage());
            return status;
        }
    }

    public Map<String, Object> getCallVolumeStats() {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            LocalDate now = LocalDate.now();
            queryParams.put("AnswerTimeStart", DateUtils.getZonedDateTimeFormat((LocalDateTime)now.minusDays(6L).atStartOfDay()));
            queryParams.put("AnswerTimeEnd", DateUtils.getZonedDateTimeFormat((LocalDateTime)now.plusDays(1L).atStartOfDay()));
            Object[] params = new Object[]{queryParams};
            Map result = (Map)this.callCgRatesApi("CDRsV1.GetCDRs", (Object)params, Map.class);
            List cdrs = (List)result.get("result");
            HashMap<String, Integer> hourlyStats = new HashMap<String, Integer>();
            if (CollectionUtils.isNotEmpty((Collection)cdrs)) {
                for (Map cdr : cdrs) {
                    String setupTime = (String)cdr.get("AnswerTime");
                    if (setupTime == null) continue;
                    String hour = setupTime.substring(11, 13) + ":00";
                    hourlyStats.put(hour, hourlyStats.getOrDefault(hour, 0) + 1);
                }
            }
            ArrayList data = new ArrayList();
            int currentHour = 23;
            for (int i = 0; i <= currentHour; ++i) {
                String time = String.format("%02d:00", i);
                HashMap<String, Object> point = new HashMap<String, Object>();
                point.put("time", time);
                point.put("value", hourlyStats.getOrDefault(time, 0));
                data.add(point);
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("data", data);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u901a\u8bdd\u91cf\u7edf\u8ba1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public Map<String, Object> getRevenueStats() {
        try {
            ArrayList data = new ArrayList();
            LocalDate today = LocalDate.now();
            for (int i = 6; i >= 0; --i) {
                LocalDate date = today.minusDays(i);
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("AnswerTimeStart", DateUtils.getZonedDateTimeFormat((LocalDateTime)date.atStartOfDay()));
                queryParams.put("AnswerTimeEnd", DateUtils.getZonedDateTimeFormat((LocalDateTime)date.plusDays(1L).atStartOfDay()));
                Object[] params = new Object[]{queryParams};
                Map result = (Map)this.callCgRatesApi("CDRsV1.GetCDRs", (Object)params, Map.class);
                double dailyRevenue = 0.0;
                List cdrs = (List)result.get("result");
                if (CollectionUtils.isNotEmpty((Collection)cdrs)) {
                    for (Map cdr : cdrs) {
                        Object cost = cdr.get("Cost");
                        if (cost == null) continue;
                        double parsedDouble = Double.parseDouble(cost.toString());
                        dailyRevenue += parsedDouble > 0.0 ? parsedDouble : 0.0;
                    }
                }
                HashMap<String, Object> point = new HashMap<String, Object>();
                point.put("day", this.getDayOfWeek(date));
                point.put("value", dailyRevenue);
                data.add(point);
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("data", data);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u6536\u5165\u7edf\u8ba1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public Map<String, Object> getAccountStatusDistribution() {
        try {
            Object[] params = new Object[]{new HashMap()};
            Map result = (Map)this.callCgRatesApi("APIerSv2.GetAccounts", (Object)params, Map.class);
            List accounts = (List)result.get("result");
            int activeCount = 0;
            int inactiveCount = 0;
            int disabledCount = 0;
            if (CollectionUtils.isNotEmpty((Collection)accounts)) {
                for (Map account : accounts) {
                    Object value;
                    List monetaryBalances;
                    Boolean disabled = (Boolean)account.get("Disabled");
                    Double balance = null;
                    Map balanceMap = (Map)account.get("BalanceMap");
                    if (balanceMap != null && CollectionUtils.isNotEmpty((Collection)(monetaryBalances = (List)balanceMap.get("*monetary"))) && (value = ((Map)monetaryBalances.get(0)).get("Value")) != null) {
                        balance = Double.parseDouble(value.toString());
                    }
                    String id = (String)account.get("ID");
                    String tenant = id.split(":")[0];
                    String accountNo = id.split(":")[1];
                    8 map = new /* Unavailable Anonymous Inner Class!! */;
                    Long count = (Long)this.callCgRatesApiForResult("APIerSv2.CountCDRs", (Object)new Object[]{map}, Long.class);
                    if (disabled != null && disabled.booleanValue()) {
                        ++disabledCount;
                        continue;
                    }
                    if (count > 0L) {
                        ++activeCount;
                        continue;
                    }
                    ++inactiveCount;
                }
            }
            ArrayList data = new ArrayList();
            HashMap<String, Object> active = new HashMap<String, Object>();
            active.put("name", MessageUtils.getMessage((String)"account.active", (Object[])new Object[0]));
            active.put("value", activeCount);
            HashMap<String, Object> inactive = new HashMap<String, Object>();
            inactive.put("name", MessageUtils.getMessage((String)"account.inactive", (Object[])new Object[0]));
            inactive.put("value", inactiveCount);
            HashMap<String, Object> disabled = new HashMap<String, Object>();
            disabled.put("name", MessageUtils.getMessage((String)"account.suspended", (Object[])new Object[0]));
            disabled.put("value", disabledCount);
            data.add(active);
            data.add(inactive);
            data.add(disabled);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("data", data);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u8d26\u6237\u72b6\u6001\u5206\u5e03\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private String getDayOfWeek(LocalDate date) {
        String[] days = new String[]{MessageUtils.getMessage((String)"dashboard.monday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.tuesday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.wednesday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.thursday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.friday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.saturday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.sunday", (Object[])new Object[0])};
        return days[date.getDayOfWeek().getValue() - 1];
    }

    public void batchAddAccount(List<AccountVo> accountVos) {
        List partition = Lists.partition(accountVos, (int)500);
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        for (List accountVoList : partition) {
            this.threadPoolTaskExecutor.execute(() -> {
                try {
                    for (AccountVo accountVo : accountVoList) {
                        HashMap<String, Object> accountParams = new HashMap<String, Object>();
                        accountParams.put("Tenant", accountVo.getTenant());
                        accountParams.put("Account", accountVo.getAccount());
                        HashMap<String, Boolean> extraOptions = new HashMap<String, Boolean>();
                        extraOptions.put("AllowNegative", false);
                        extraOptions.put("Disabled", accountVo.getDisabled());
                        accountParams.put("ExtraOptions", extraOptions);
                        accountParams.put("APIOpts", new HashMap());
                        this.callCgRatesApi("ApierV1.SetAccount", (Object)new Object[]{accountParams}, String.class);
                        HashMap<String, Object> balanceParams = new HashMap<String, Object>();
                        balanceParams.put("Tenant", accountVo.getTenant());
                        balanceParams.put("Account", accountVo.getAccount());
                        balanceParams.put("BalanceType", "*monetary");
                        balanceParams.put("Value", accountVo.getBalance());
                        balanceParams.put("APIOpts", new HashMap());
                        this.callCgRatesApi("ApierV1.AddBalance", (Object)new Object[]{balanceParams}, String.class);
                    }
                }
                catch (Exception e) {
                    log.error("\u521b\u5efaCGRates\u7528\u6237\u5931\u8d25", (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String createAndUpdateSession(String tenant, String account, String destination) {
        String sessionId = UUID.randomUUID().toString();
        log.info("\u751f\u6210\u4f1a\u8bddID: {}", (Object)sessionId);
        HashMap<String, String> initEvent = new HashMap<String, String>();
        initEvent.put("ID", sessionId);
        initEvent.put("Tenant", tenant);
        initEvent.put("Account", account);
        initEvent.put("OriginID", sessionId);
        initEvent.put("Destination", destination);
        initEvent.put("ToR", "*voice");
        initEvent.put("RequestType", "*prepaid");
        initEvent.put("Category", "call");
        initEvent.put("Subject", account);
        initEvent.put("Source", "TEST");
        initEvent.put("SetupTime", System.currentTimeMillis() / 1000L + "");
        initEvent.put("AnswerTime", System.currentTimeMillis() / 1000L + "");
        HashMap<String, Object> initArgs = new HashMap<String, Object>();
        initArgs.put("InitSession", true);
        initArgs.put("GetAttributes", true);
        initArgs.put("AllocateResources", false);
        initArgs.put("Tenant", tenant);
        initArgs.put("Event", initEvent);
        Map initResult = (Map)this.callCgRatesApiForResult("SessionSv1.InitiateSession", (Object)new Object[]{initArgs}, Map.class);
        log.info("\u4f1a\u8bdd\u521d\u59cb\u5316\u6210\u529f: {}", (Object)initResult);
        for (int i = 0; i < 15; ++i) {
            HashMap<String, String> updateEvent = new HashMap<String, String>();
            updateEvent.put("ID", sessionId);
            updateEvent.put("Tenant", tenant);
            updateEvent.put("Account", account);
            updateEvent.put("OriginID", sessionId);
            updateEvent.put("ToR", "*voice");
            updateEvent.put("RequestType", "*prepaid");
            updateEvent.put("Usage", "6s");
            updateEvent.put("LastUsed", System.currentTimeMillis() / 1000L + "");
            updateEvent.put("Time", System.currentTimeMillis() / 1000L + "");
            updateEvent.put("Destination", destination);
            updateEvent.put("Category", "call");
            updateEvent.put("Subject", account);
            HashMap<String, Object> cgrEvent = new HashMap<String, Object>();
            cgrEvent.put("ID", sessionId);
            cgrEvent.put("Tenant", tenant);
            cgrEvent.put("Time", System.currentTimeMillis() / 1000L + "");
            cgrEvent.put("Event", updateEvent);
            HashMap<String, Serializable> updateArgs = new HashMap<String, Serializable>();
            updateArgs.put("UpdateSession", Boolean.valueOf(true));
            updateArgs.put("ForceDuration", Boolean.valueOf(true));
            updateArgs.put("GetAttributes", Boolean.valueOf(false));
            updateArgs.put("Event", updateEvent);
            Map updateResult = (Map)this.callCgRatesApiForResult("SessionSv1.UpdateSession", (Object)new Object[]{updateArgs}, Map.class);
            log.info("\u4f1a\u8bdd\u66f4\u65b0\u6210\u529f: {}", (Object)updateResult);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return sessionId;
    }

    public void loadTariffPlanFromStorDb() {
        HashMap<String, Object> loadParams = new HashMap<String, Object>();
        loadParams.put("TPid", DEFAULT_TP_ID);
        loadParams.put("DryRun", false);
        loadParams.put("FlushDb", true);
        loadParams.put("Validate", true);
        loadParams.put("APIOpts", new /* Unavailable Anonymous Inner Class!! */);
        String string = (String)this.callCgRatesApi("APIerSv1.LoadTariffPlanFromStorDb", (Object)new Object[]{loadParams}, String.class);
        log.info("LoadTariffPlanFromStorDb result - {}", (Object)string);
    }
}

