/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.exception.RRException;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.Query;
import com.bms.modules.sys.dao.SysUserDao;
import com.bms.modules.sys.entity.SysUserEntity;
import com.bms.modules.sys.service.SysRoleService;
import com.bms.modules.sys.service.SysUserRoleService;
import com.bms.modules.sys.service.SysUserService;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserService")
public class SysUserServiceImpl
extends ServiceImpl<SysUserDao, SysUserEntity>
implements SysUserService {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleService sysRoleService;

    public PageUtils queryPage(Map<String, Object> params) {
        String username = (String)params.get("username");
        Long createUserId = (Long)params.get("createUserId");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)username), (Object)"username", (Object)username)).eq(createUserId != null, (Object)"create_user_id", (Object)createUserId));
        return new PageUtils(page);
    }

    public List<String> queryAllPerms(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllPerms(userId);
    }

    public List<Long> queryAllMenuId(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllMenuId(userId);
    }

    public SysUserEntity queryByUserName(String username) {
        return ((SysUserDao)this.baseMapper).queryByUserName(username);
    }

    @Transactional
    public void saveUser(SysUserEntity user) {
        user.setCreateTime(Date.from(Instant.now()));
        String salt = RandomStringUtils.randomAlphanumeric((int)20);
        user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)salt).toHex());
        user.setSalt(salt);
        this.save((Object)user);
        this.checkRole(user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    @Transactional
    public void update(SysUserEntity user) {
        if (StringUtils.isBlank((String)user.getPassword())) {
            user.setPassword(null);
        } else {
            user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)user.getSalt()).toHex());
        }
        this.updateById((Object)user);
        this.checkRole(user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    public void deleteBatch(Long[] userId) {
        this.removeByIds(Arrays.asList(userId));
    }

    public boolean updatePassword(Long userId, String password, String newPassword) {
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setPassword(newPassword);
        return this.update((Object)userEntity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"password", (Object)password));
    }

    private void checkRole(SysUserEntity user) {
        if (user.getRoleIdList() == null || user.getRoleIdList().size() == 0) {
            return;
        }
        if (user.getCreateUserId() == 1L) {
            return;
        }
        List roleIdList = this.sysRoleService.queryRoleIdList(user.getCreateUserId());
        if (!roleIdList.containsAll(user.getRoleIdList())) {
            throw new RRException(MessageUtils.getMessage((String)"role.not.selfCreate", (Object[])new Object[0]));
        }
    }
}

