/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.enums.RedisKeyEnum;
import com.bms.common.exception.RRException;
import com.bms.common.utils.DateUtils;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.RedisUtils;
import com.bms.modules.sys.dao.SysCaptchaDao;
import com.bms.modules.sys.entity.SysCaptchaEntity;
import com.bms.modules.sys.service.SysCaptchaService;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysCaptchaService")
public class SysCaptchaServiceImpl
extends ServiceImpl<SysCaptchaDao, SysCaptchaEntity>
implements SysCaptchaService {
    @Autowired
    private Producer producer;
    @Autowired
    private RedisUtils redisUtils;

    public BufferedImage getCaptcha(String uuid) {
        if (StringUtils.isBlank((String)uuid)) {
            throw new RRException(MessageUtils.getMessage((String)"captcha.uuid.notNull", (Object[])new Object[0]));
        }
        String code = this.producer.createText();
        SysCaptchaEntity captchaEntity = new SysCaptchaEntity();
        captchaEntity.setUuid(uuid);
        captchaEntity.setCode(code);
        captchaEntity.setExpireTime(DateUtils.addDateMinutes((Date)Date.from(Instant.now()), (int)5));
        Boolean open = this.redisUtils.getOpen();
        if (open.booleanValue()) {
            this.redisUtils.set(RedisKeyEnum.LOGIN_CAPTCHA.getKey() + captchaEntity.getUuid(), (Object)captchaEntity, (long)RedisKeyEnum.LOGIN_CAPTCHA.getExpireTime().intValue());
        } else {
            this.save((Object)captchaEntity);
        }
        return this.producer.createImage(code);
    }

    public boolean validate(String uuid, String code) {
        Boolean open = this.redisUtils.getOpen();
        SysCaptchaEntity captchaEntity = open != false ? (SysCaptchaEntity)this.redisUtils.get(RedisKeyEnum.LOGIN_CAPTCHA.getKey() + uuid, SysCaptchaEntity.class) : (SysCaptchaEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", (Object)uuid));
        if (captchaEntity == null) {
            return false;
        }
        this.removeById((Serializable)((Object)uuid));
        this.redisUtils.delete(RedisKeyEnum.LOGIN_CAPTCHA.getKey() + uuid);
        return captchaEntity.getCode().equalsIgnoreCase(code) && captchaEntity.getExpireTime().getTime() >= System.currentTimeMillis();
    }
}

