/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.jwt;

import com.bms.modules.sys.entity.SysUserEntity;
import com.bms.modules.sys.jwt.JWTToken;
import com.bms.modules.sys.service.ShiroService;
import com.bms.modules.sys.service.SysUserTokenService;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JWTRealm
extends AuthorizingRealm {
    @Autowired
    private ShiroService shiroService;
    @Autowired
    private SysUserTokenService sysUserTokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SysUserEntity user = (SysUserEntity)principals.getPrimaryPrincipal();
        Long userId = user.getUserId();
        Set permsSet = this.shiroService.getUserPermissions(userId.longValue());
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.setStringPermissions(permsSet);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String accessToken = (String)token.getPrincipal();
        Long userId = this.sysUserTokenService.getUserIdByToken(accessToken);
        if (userId == null) {
            throw new IncorrectCredentialsException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        SysUserEntity user = this.shiroService.queryUser(userId);
        if (user.getStatus() == 0) {
            throw new LockedAccountException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user, (Object)accessToken, this.getName());
        return info;
    }
}

