/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.annotation.SysLog;
import com.bms.common.exception.RRException;
import com.bms.common.utils.Constant;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.R;
import com.bms.modules.sys.controller.AbstractController;
import com.bms.modules.sys.entity.SysMenuEntity;
import com.bms.modules.sys.service.ShiroService;
import com.bms.modules.sys.service.SysMenuService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu"})
public class SysMenuController
extends AbstractController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @GetMapping(value={"/nav"})
    public R nav() {
        List menuList = this.sysMenuService.getUserMenuList(this.getUserId());
        Set permissions = this.shiroService.getUserPermissions(this.getUserId().longValue());
        return R.ok().put("menuList", (Object)menuList).put("permissions", (Object)permissions);
    }

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:menu:list"})
    public List<SysMenuEntity> list() {
        List menuList = this.sysMenuService.list();
        Collections.sort(menuList);
        HashMap<Long, SysMenuEntity> menuMap = new HashMap<Long, SysMenuEntity>(12);
        for (SysMenuEntity s : menuList) {
            menuMap.put(s.getMenuId(), s);
        }
        for (SysMenuEntity s : menuList) {
            SysMenuEntity parent = (SysMenuEntity)menuMap.get(s.getParentId());
            if (!Objects.nonNull(parent)) continue;
            s.setParentName(parent.getName());
        }
        return menuList;
    }

    @GetMapping(value={"/select"})
    @RequiresPermissions(value={"sys:menu:select"})
    public R select() {
        List menuList = this.sysMenuService.queryNotButtonList();
        SysMenuEntity root = new SysMenuEntity();
        root.setMenuId(Long.valueOf(0L));
        root.setNameCn("\u9876\u7ea7\u83dc\u5355");
        root.setNameEn("Top menu");
        root.setParentId(Long.valueOf(-1L));
        root.setOpen(Boolean.valueOf(true));
        menuList.add(root);
        return R.ok().put("menuList", (Object)menuList);
    }

    @GetMapping(value={"/info/{menuId}"})
    @RequiresPermissions(value={"sys:menu:info"})
    public R info(@PathVariable(value="menuId") Long menuId) {
        SysMenuEntity menu = (SysMenuEntity)this.sysMenuService.getById((Serializable)menuId);
        return R.ok().put("menu", (Object)menu);
    }

    @SysLog(value="Save Menu")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:menu:save"})
    public R save(@RequestBody SysMenuEntity menu) {
        this.verifyForm(menu);
        this.sysMenuService.save((Object)menu);
        return R.ok();
    }

    @SysLog(value="Update Menu")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:menu:update"})
    public R update(@RequestBody SysMenuEntity menu) {
        this.verifyForm(menu);
        this.sysMenuService.updateById((Object)menu);
        return R.ok();
    }

    @SysLog(value="Delete Menu")
    @PostMapping(value={"/delete/{menuId}"})
    @RequiresPermissions(value={"sys:menu:delete"})
    public R delete(@PathVariable(value="menuId") long menuId) {
        if (menuId <= 31L) {
            return R.error((String)MessageUtils.getMessage((String)"menu.isSystem.cannot.delete", (Object[])new Object[0]));
        }
        List menuList = this.sysMenuService.queryListParentId(Long.valueOf(menuId));
        if (!menuList.isEmpty()) {
            return R.error((String)MessageUtils.getMessage((String)"menu.has.child", (Object[])new Object[0]));
        }
        this.sysMenuService.delete(Long.valueOf(menuId));
        return R.ok();
    }

    private void verifyForm(SysMenuEntity menu) {
        if (StringUtils.isBlank((String)menu.getNameCn())) {
            throw new RRException(MessageUtils.getMessage((String)"menu.nameCn.notNull", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)menu.getNameEn())) {
            throw new RRException(MessageUtils.getMessage((String)"menu.nameEn.notNull", (Object[])new Object[0]));
        }
        if (menu.getParentId() == null) {
            throw new RRException(MessageUtils.getMessage((String)"menu.parentId.notNull", (Object[])new Object[0]));
        }
        if (menu.getType().intValue() == Constant.MenuType.MENU.getValue() && StringUtils.isBlank((String)menu.getUrl())) {
            throw new RRException(MessageUtils.getMessage((String)"menu.url.notNull", (Object[])new Object[0]));
        }
        int parentType = Constant.MenuType.CATALOG.getValue();
        if (menu.getParentId() != 0L) {
            SysMenuEntity parentMenu = (SysMenuEntity)this.sysMenuService.getById((Serializable)menu.getParentId());
            parentType = parentMenu.getType();
        }
        if (menu.getType().intValue() == Constant.MenuType.CATALOG.getValue() || menu.getType().intValue() == Constant.MenuType.MENU.getValue()) {
            if (parentType != Constant.MenuType.CATALOG.getValue()) {
                throw new RRException(MessageUtils.getMessage((String)"menu.parent.type.needDir", (Object[])new Object[0]));
            }
            return;
        }
        if (menu.getType().intValue() == Constant.MenuType.BUTTON.getValue() && parentType != Constant.MenuType.MENU.getValue()) {
            throw new RRException(MessageUtils.getMessage((String)"menu.parent.type.needMenu", (Object[])new Object[0]));
        }
    }
}

