/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.LocaleResolver;

@RestController
@RequestMapping(value={"/sys/language"})
@Api(tags={"\u8bed\u8a00\u7ba1\u7406"})
public class SysLanguageController {
    @Autowired
    private LocaleResolver localeResolver;

    @PostMapping(value={"/change"})
    @ApiOperation(value="\u5207\u6362\u8bed\u8a00")
    public R changeLanguage(@RequestParam String language, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale;
            switch (language) {
                case "en": {
                    locale = Locale.ENGLISH;
                    break;
                }
                case "zh-CN": {
                    locale = Locale.SIMPLIFIED_CHINESE;
                    break;
                }
                default: {
                    locale = Locale.SIMPLIFIED_CHINESE;
                }
            }
            this.localeResolver.setLocale(request, response, locale);
            return R.ok().put("message", (Object)MessageUtils.getMessage((String)"common.success", (Object[])new Object[0]));
        }
        catch (Exception e) {
            return R.error().put("message", (Object)MessageUtils.getMessage((String)"common.error", (Object[])new Object[0]));
        }
    }

    @GetMapping(value={"/current"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u8bed\u8a00")
    public R getCurrentLanguage(HttpServletRequest request) {
        Locale locale = this.localeResolver.resolveLocale(request);
        String language = locale.toString().replace("_", "-");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("language", language);
        data.put("locale", locale);
        return R.ok().put("data", data);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u8bed\u8a00\u5217\u8868")
    public R getLanguageList() {
        HashMap<String, String> languages = new HashMap<String, String>();
        languages.put("zh-CN", "\u7b80\u4f53\u4e2d\u6587");
        languages.put("en", "English");
        return R.ok().put("data", languages);
    }
}

