/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.annotation.SysLog;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.R;
import com.bms.common.validator.ValidatorUtils;
import com.bms.modules.sys.controller.AbstractController;
import com.bms.modules.sys.entity.SysConfigEntity;
import com.bms.modules.sys.service.SysConfigService;
import java.io.Serializable;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/config"})
public class SysConfigController
extends AbstractController {
    @Autowired
    private SysConfigService sysConfigService;

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:config:list"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.sysConfigService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/info/{id}"})
    @RequiresPermissions(value={"sys:config:info"})
    public R info(@PathVariable(value="id") Long id) {
        SysConfigEntity config = (SysConfigEntity)this.sysConfigService.getById((Serializable)id);
        return R.ok().put("config", (Object)config);
    }

    @SysLog(value="Save Config")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:config:save"})
    public R save(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity((Object)config, (Class[])new Class[0]);
        this.sysConfigService.saveConfig(config);
        return R.ok();
    }

    @SysLog(value="Update Config")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:config:update"})
    public R update(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity((Object)config, (Class[])new Class[0]);
        this.sysConfigService.update(config);
        return R.ok();
    }

    @SysLog(value="Delete Config")
    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:config:delete"})
    public R delete(@RequestBody Long[] ids) {
        this.sysConfigService.deleteBatch(ids);
        return R.ok();
    }
}

