/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.annotation.SysLog;
import com.bms.common.model.BackupSettingVo;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.R;
import com.bms.modules.sys.entity.SysBackupRecord;
import com.bms.modules.sys.service.SysBackupRecordService;
import com.bms.service.SysBackupService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/backup"})
public class SysBackupController {
    @Autowired
    private SysBackupService backupService;
    @Autowired
    private SysBackupRecordService backupRecordService;

    @PostMapping(value={"/record/page"})
    public R recordPage(@RequestBody Map<String, Object> params) {
        PageUtils page = this.backupRecordService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @SysLog(value="Delete Backup Record")
    @PostMapping(value={"/record/remove"})
    public R removeRecord(@RequestBody List<Long> ids) {
        this.backupRecordService.removeRecord(ids);
        return R.ok();
    }

    @SysLog(value="Execute Backup")
    @PostMapping(value={"/execute"})
    public R executeBackup(@RequestBody SysBackupRecord backupRecord) {
        this.backupService.executeBackup("manual", backupRecord.getDescription());
        return R.ok();
    }

    @SysLog(value="Save Backup Setting")
    @PostMapping(value={"/setting"})
    public R setting(@RequestBody BackupSettingVo backupSettingVo) {
        this.backupService.saveBackupSetting(backupSettingVo);
        return R.ok();
    }

    @GetMapping(value={"/setting"})
    public R setting() {
        BackupSettingVo backupSettingVo = this.backupService.getBackupSetting();
        return R.ok().put("data", (Object)backupSettingVo);
    }

    @SysLog(value="Recover Backup")
    @PostMapping(value={"/recover/{id}"})
    public R recoverBackup(@PathVariable Long id) {
        this.backupService.recoverBackup(id);
        return R.ok();
    }
}

