/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.oss.cloud;

import com.bms.common.utils.Constant;
import com.bms.common.utils.SpringContextUtils;
import com.bms.modules.oss.cloud.AliyunCloudStorageService;
import com.bms.modules.oss.cloud.CloudStorageConfig;
import com.bms.modules.oss.cloud.CloudStorageService;
import com.bms.modules.oss.cloud.QcloudCloudStorageService;
import com.bms.modules.oss.cloud.QiniuCloudStorageService;
import com.bms.modules.sys.service.SysConfigService;

public final class OSSFactory {
    private static SysConfigService sysConfigService = (SysConfigService)SpringContextUtils.getBean((String)"sysConfigService");

    public static CloudStorageService build() {
        CloudStorageConfig config = (CloudStorageConfig)sysConfigService.getConfigObject("CLOUD_STORAGE_CONFIG_KEY", CloudStorageConfig.class);
        if (config.getType().intValue() == Constant.CloudService.QINIU.getValue()) {
            return new QiniuCloudStorageService(config);
        }
        if (config.getType().intValue() == Constant.CloudService.ALIYUN.getValue()) {
            return new AliyunCloudStorageService(config);
        }
        if (config.getType().intValue() == Constant.CloudService.QCLOUD.getValue()) {
            return new QcloudCloudStorageService(config);
        }
        return null;
    }
}

