/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.utils;

import com.bms.common.exception.RRException;
import com.bms.common.utils.Constant;
import com.bms.modules.job.entity.ScheduleJobEntity;
import com.bms.modules.job.utils.ScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScheduleUtils {
    private static final String JOB_NAME = "TASK_";

    public static TriggerKey getTriggerKey(Long jobId) {
        return TriggerKey.triggerKey((String)("TASK_" + jobId));
    }

    public static JobKey getJobKey(Long jobId) {
        return JobKey.jobKey((String)("TASK_" + jobId));
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, Long jobId) {
        try {
            return (CronTrigger)scheduler.getTrigger(ScheduleUtils.getTriggerKey((Long)jobId));
        }
        catch (SchedulerException e) {
            throw new RRException("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void createScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ScheduleJob.class).withIdentity(ScheduleUtils.getJobKey((Long)scheduleJob.getJobId())).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey((Long)scheduleJob.getJobId())).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            jobDetail.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob((Scheduler)scheduler, (Long)scheduleJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new RRException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void updateScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey((Long)scheduleJob.getJobId());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = ScheduleUtils.getCronTrigger((Scheduler)scheduler, (Long)scheduleJob.getJobId());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            trigger.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob((Scheduler)scheduler, (Long)scheduleJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new RRException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void run(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.triggerJob(ScheduleUtils.getJobKey((Long)scheduleJob.getJobId()), dataMap);
        }
        catch (SchedulerException e) {
            throw new RRException("\u7acb\u5373\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void pauseJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.pauseJob(ScheduleUtils.getJobKey((Long)jobId));
        }
        catch (SchedulerException e) {
            throw new RRException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void resumeJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.resumeJob(ScheduleUtils.getJobKey((Long)jobId));
        }
        catch (SchedulerException e) {
            throw new RRException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, Long jobId) {
        try {
            scheduler.deleteJob(ScheduleUtils.getJobKey((Long)jobId));
        }
        catch (SchedulerException e) {
            throw new RRException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

