/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.utils;

import com.bms.common.utils.SpringContextUtils;
import com.bms.modules.job.entity.ScheduleJobEntity;
import com.bms.modules.job.entity.ScheduleJobLogEntity;
import com.bms.modules.job.service.ScheduleJobLogService;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ScheduleJob
extends QuartzJobBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ScheduleJobEntity scheduleJob = (ScheduleJobEntity)context.getMergedJobDataMap().get((Object)"JOB_PARAM_KEY");
        ScheduleJobLogService scheduleJobLogService = (ScheduleJobLogService)SpringContextUtils.getBean((String)"scheduleJobLogService");
        ScheduleJobLogEntity log = new ScheduleJobLogEntity();
        log.setJobId(scheduleJob.getJobId());
        log.setBeanName(scheduleJob.getBeanName());
        log.setParams(scheduleJob.getParams());
        log.setCreateTime(Date.from(Instant.now()));
        long startTime = System.currentTimeMillis();
        try {
            this.logger.debug("\u4efb\u52a1\u51c6\u5907\u6267\u884c\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId());
            Object target = SpringContextUtils.getBean((String)scheduleJob.getBeanName());
            Method method = target.getClass().getDeclaredMethod("run", String.class);
            method.invoke(target, scheduleJob.getParams());
            long times = System.currentTimeMillis() - startTime;
            log.setTimes(Integer.valueOf((int)times));
            log.setStatus(Integer.valueOf(0));
            this.logger.debug("\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId() + "  \u603b\u5171\u8017\u65f6\uff1a" + times + "\u6beb\u79d2");
        }
        catch (Exception e) {
            try {
                this.logger.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1ID\uff1a" + scheduleJob.getJobId(), (Throwable)e);
                long times = System.currentTimeMillis() - startTime;
                log.setTimes(Integer.valueOf((int)times));
                log.setStatus(Integer.valueOf(1));
                log.setError(StringUtils.substring((String)e.toString(), (int)0, (int)2000));
            }
            catch (Throwable throwable) {
                if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)scheduleJob.getBeanName(), (CharSequence[])new CharSequence[]{"cdrReadTask", "processBillTask", "systemStatusReadTask"})) {
                    return;
                }
                scheduleJobLogService.save((Object)log);
                throw throwable;
            }
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)scheduleJob.getBeanName(), (CharSequence[])new CharSequence[]{"cdrReadTask", "processBillTask", "systemStatusReadTask"})) {
                return;
            }
            scheduleJobLogService.save((Object)log);
        }
        if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)scheduleJob.getBeanName(), (CharSequence[])new CharSequence[]{"cdrReadTask", "processBillTask", "systemStatusReadTask"})) {
            return;
        }
        scheduleJobLogService.save((Object)log);
    }
}

