/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.controller;

import com.bms.common.annotation.SysLog;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.R;
import com.bms.common.validator.ValidatorUtils;
import com.bms.modules.job.entity.ScheduleJobEntity;
import com.bms.modules.job.service.ScheduleJobService;
import java.io.Serializable;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/schedule"})
public class ScheduleJobController {
    @Autowired
    private ScheduleJobService scheduleJobService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"sys:schedule:list"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.scheduleJobService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @RequestMapping(value={"/info/{jobId}"})
    @RequiresPermissions(value={"sys:schedule:info"})
    public R info(@PathVariable(value="jobId") Long jobId) {
        ScheduleJobEntity schedule = (ScheduleJobEntity)this.scheduleJobService.getById((Serializable)jobId);
        return R.ok().put("schedule", (Object)schedule);
    }

    @SysLog(value="Save Schedule Job")
    @RequestMapping(value={"/save"})
    @RequiresPermissions(value={"sys:schedule:save"})
    public R save(@RequestBody ScheduleJobEntity scheduleJob) {
        ValidatorUtils.validateEntity((Object)scheduleJob, (Class[])new Class[0]);
        this.scheduleJobService.saveJob(scheduleJob);
        return R.ok();
    }

    @SysLog(value="Update Schedule Job")
    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"sys:schedule:update"})
    public R update(@RequestBody ScheduleJobEntity scheduleJob) {
        ValidatorUtils.validateEntity((Object)scheduleJob, (Class[])new Class[0]);
        this.scheduleJobService.update(scheduleJob);
        return R.ok();
    }

    @SysLog(value="Delete Schedule Job")
    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:schedule:delete"})
    public R delete(@RequestBody Long[] jobIds) {
        this.scheduleJobService.deleteBatch(jobIds);
        return R.ok();
    }

    @SysLog(value="Execute Schedule Job")
    @RequestMapping(value={"/run"})
    @RequiresPermissions(value={"sys:schedule:run"})
    public R run(@RequestBody Long[] jobIds) {
        this.scheduleJobService.run(jobIds);
        return R.ok();
    }

    @SysLog(value="Pause Schedule Job")
    @RequestMapping(value={"/pause"})
    @RequiresPermissions(value={"sys:schedule:pause"})
    public R pause(@RequestBody Long[] jobIds) {
        this.scheduleJobService.pause(jobIds);
        return R.ok();
    }

    @SysLog(value="Resume Schedule Job")
    @RequestMapping(value={"/resume"})
    @RequiresPermissions(value={"sys:schedule:resume"})
    public R resume(@RequestBody Long[] jobIds) {
        this.scheduleJobService.resume(jobIds);
        return R.ok();
    }
}

