/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.dashboard.service;

import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.SystemStatusUtils;
import com.bms.modules.job.task.SystemStatusReadTask;
import com.bms.service.CgRatesService;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);
    @Autowired
    private CgRatesService cgratesService;
    @Autowired
    SystemStatusReadTask systemStatusReadTask;

    public Map<String, Object> getSystemOverview() {
        HashMap<String, Object> overview = new HashMap<String, Object>();
        try {
            Map accountStats = this.cgratesService.getAccountStats();
            overview.put("totalAccounts", accountStats.getOrDefault("total", 0));
            overview.put("activeCalls", this.getActiveCallsCount());
            overview.put("todayRevenue", this.getTodayRevenue());
            overview.put("systemStatus", this.getSystemStatus());
        }
        catch (Exception e) {
            overview.put("totalAccounts", 0);
            overview.put("activeCalls", 0);
            overview.put("todayRevenue", "0.00");
            overview.put("systemStatus", MessageUtils.getMessage((String)"dashboard.systemStatus.offline", (Object[])new Object[0]));
        }
        return overview;
    }

    public List<Map<String, Object>> getSystemAlerts() {
        ArrayList<Map<String, Object>> alerts = new ArrayList<Map<String, Object>>();
        try {
            double diskUsage;
            long memoryUsage;
            Map status = this.cgratesService.getSystemStatus();
            if (!"OK".equals(status.get("status"))) {
                alerts.add(this.createAlert("critical", MessageUtils.getMessage((String)"dashboard.connetcCgratesFailed", (Object[])new Object[0]), LocalDateTime.now()));
            }
            if ((memoryUsage = SystemStatusUtils.getSystemMemoryLoad()) > 80L) {
                alerts.add(this.createAlert("warning", MessageUtils.getMessage((String)"dashboard.memoryUsage.tooHigh", (Object[])new Object[]{memoryUsage}), LocalDateTime.now()));
            }
            if ((diskUsage = (double)SystemStatusUtils.getDiskUsage()) > 90.0) {
                alerts.add(this.createAlert("critical", MessageUtils.getMessage((String)"dashboard.diskUsage.insufficient", (Object[])new Object[]{diskUsage}), LocalDateTime.now()));
            }
        }
        catch (Exception e) {
            alerts.add(this.createAlert("critical", MessageUtils.getMessage((String)"dashboard.sysMonitorServiceError", (Object[])new Object[]{e.getMessage()}), LocalDateTime.now()));
        }
        return alerts;
    }

    public Map<String, Object> getKeyMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("callVolume", this.getCallVolumeData());
        metrics.put("revenue", this.getRevenueData());
        metrics.put("totalRevenue", this.getTotalRevenue());
        metrics.put("accountStatus", this.getAccountStatusData());
        metrics.put("systemLoad", this.systemStatusReadTask.getLast12HoursSystemStatus());
        return metrics;
    }

    private int getActiveCallsCount() {
        try {
            Map sessions = this.cgratesService.getActiveSessions();
            return sessions.getOrDefault("count", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getTodayRevenue() {
        try {
            Map revenue = this.cgratesService.getTodayRevenue();
            return revenue.getOrDefault("amount", "0.00").toString();
        }
        catch (Exception e) {
            return "0.00";
        }
    }

    private String getTotalRevenue() {
        try {
            Map revenue = this.cgratesService.getTotalRevenue();
            return revenue.getOrDefault("amount", "0.00").toString();
        }
        catch (Exception e) {
            return "0.00";
        }
    }

    private String getSystemStatus() {
        try {
            Map status = this.cgratesService.getSystemStatus();
            return "OK".equals(status.get("status")) ? MessageUtils.getMessage((String)"dashboard.systemStatus.normal", (Object[])new Object[0]) : MessageUtils.getMessage((String)"dashboard.systemStatus.error", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return MessageUtils.getMessage((String)"dashboard.systemStatus.offline", (Object[])new Object[0]);
        }
    }

    private Map<String, Object> createAlert(String level, String message, LocalDateTime time) {
        HashMap<String, Object> alert = new HashMap<String, Object>();
        alert.put("level", level);
        alert.put("message", message);
        alert.put("time", time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return alert;
    }

    private double getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(totalMemory - freeMemory) / (double)totalMemory * 100.0;
    }

    private double getDiskUsage() {
        return Math.random() * 100.0;
    }

    private List<Map<String, Object>> getCallVolumeData() {
        try {
            Map callStats = this.cgratesService.getCallVolumeStats();
            List data = (List)callStats.get("data");
            if (data != null && !data.isEmpty()) {
                return data;
            }
        }
        catch (Exception callStats) {
            // empty catch block
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String[] times = new String[]{"00:00", "04:00", "08:00", "12:00", "16:00", "20:00"};
        int[] values = new int[]{120, 200, 150, 80, 70, 110};
        for (int i = 0; i < times.length; ++i) {
            HashMap<String, Object> point = new HashMap<String, Object>();
            point.put("time", times[i]);
            point.put("value", values[i]);
            data.add(point);
        }
        return data;
    }

    private List<Map<String, Object>> getRevenueData() {
        try {
            Map revenueStats = this.cgratesService.getRevenueStats();
            List data = (List)revenueStats.get("data");
            if (data != null && !data.isEmpty()) {
                return data;
            }
        }
        catch (Exception revenueStats) {
            // empty catch block
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        String[] days = new String[]{MessageUtils.getMessage((String)"dashboard.monday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.tuesday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.wednesday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.thursday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.friday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.saturday", (Object[])new Object[0]), MessageUtils.getMessage((String)"dashboard.sunday", (Object[])new Object[0])};
        double[] values = new double[]{820.5, 932.8, 901.2, 934.6, 1290.3, 1330.7, 1320.9};
        for (int i = 0; i < days.length; ++i) {
            HashMap<String, Object> point = new HashMap<String, Object>();
            point.put("day", days[i]);
            point.put("value", values[i]);
            data.add(point);
        }
        return data;
    }

    private List<Map<String, Object>> getAccountStatusData() {
        try {
            Map accountStats = this.cgratesService.getAccountStatusDistribution();
            List data = (List)accountStats.get("data");
            if (data != null && !data.isEmpty()) {
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Map<String, Object>>();
    }

    private Map<String, Object> getSystemLoadData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            ArrayList<Double> cpuData = new ArrayList<Double>();
            ArrayList<Double> memoryData = new ArrayList<Double>();
            ArrayList<Double> diskData = new ArrayList<Double>();
            ArrayList<String> timeLabels = new ArrayList<String>();
            LocalDateTime now = LocalDateTime.now();
            for (int i = 11; i >= 0; --i) {
                double cpuUsage;
                LocalDateTime timePoint = now.minusHours(i);
                timeLabels.add(timePoint.format(DateTimeFormatter.ofPattern("HH:mm")));
                double systemLoad = osBean.getSystemLoadAverage();
                if (systemLoad > 0.0) {
                    int availableProcessors = osBean.getAvailableProcessors();
                    cpuUsage = Math.min(systemLoad / (double)availableProcessors * 100.0, 100.0);
                } else if (osBean instanceof OperatingSystemMXBean) {
                    OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
                    cpuUsage = sunOsBean.getProcessCpuLoad() * 100.0;
                    if (cpuUsage < 0.0) {
                        cpuUsage = Math.random() * 30.0 + 20.0;
                    }
                } else {
                    cpuUsage = Math.random() * 30.0 + 20.0;
                }
                cpuData.add(Math.max(0.0, Math.min(100.0, cpuUsage)));
                MemoryUsage heapMemory = memoryBean.getHeapMemoryUsage();
                double memoryUsage = (double)heapMemory.getUsed() / (double)heapMemory.getMax() * 100.0;
                memoryData.add(Math.max(0.0, Math.min(100.0, memoryUsage)));
                double diskUsage = this.getDiskUsagePercentage();
                diskData.add(Math.max(0.0, Math.min(100.0, diskUsage)));
            }
            data.put("cpu", cpuData);
            data.put("memory", memoryData);
            data.put("disk", diskData);
            data.put("timeLabels", timeLabels);
            data.put("currentCpu", cpuData.get(cpuData.size() - 1));
            data.put("currentMemory", memoryData.get(memoryData.size() - 1));
            data.put("currentDisk", diskData.get(diskData.size() - 1));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u8d1f\u8f7d\u6570\u636e\u5931\u8d25", (Throwable)e);
            data.put("cpu", Arrays.asList(30, 32, 35, 40, 45, 50, 48, 46, 44, 42, 40, 38));
            data.put("memory", Arrays.asList(60, 62, 65, 70, 68, 72, 70, 68, 66, 64, 62, 60));
            data.put("disk", Arrays.asList(20, 21, 22, 25, 28, 30, 32, 31, 29, 27, 25, 23));
            ArrayList<String> defaultTimeLabels = new ArrayList<String>();
            LocalDateTime now = LocalDateTime.now();
            for (int i = 11; i >= 0; --i) {
                defaultTimeLabels.add(now.minusHours(i).format(DateTimeFormatter.ofPattern("HH:mm")));
            }
            data.put("timeLabels", defaultTimeLabels);
        }
        return data;
    }

    private double getDiskUsagePercentage() {
        try {
            File root = new File("/");
            if (!root.exists()) {
                root = new File("C:");
            }
            long totalSpace = root.getTotalSpace();
            long freeSpace = root.getFreeSpace();
            long usedSpace = totalSpace - freeSpace;
            if (totalSpace > 0L) {
                return (double)usedSpace / (double)totalSpace * 100.0;
            }
            File currentDir = new File(".");
            totalSpace = currentDir.getTotalSpace();
            freeSpace = currentDir.getFreeSpace();
            usedSpace = totalSpace - freeSpace;
            return totalSpace > 0L ? (double)usedSpace / (double)totalSpace * 100.0 : 50.0;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u78c1\u76d8\u4f7f\u7528\u7387\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c", (Throwable)e);
            return 50.0;
        }
    }
}

