/*
 * Decompiled with CFR 0.152.
 */
package com.bms.datasource.aspect;

import com.bms.datasource.annotation.DataSource;
import com.bms.datasource.config.DynamicContextHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-2147483648)
public class DataSourceAspect {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.bms.datasource.annotation.DataSource) || @within(com.bms.datasource.annotation.DataSource)")
    public void dataSourcePointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="dataSourcePointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        Method method = signature.getMethod();
        DataSource targetDataSource = targetClass.getAnnotation(DataSource.class);
        DataSource methodDataSource = method.getAnnotation(DataSource.class);
        if (targetDataSource != null || methodDataSource != null) {
            String value = methodDataSource != null ? methodDataSource.value() : targetDataSource.value();
            DynamicContextHolder.push((String)value);
            this.logger.debug("set datasource is {}", (Object)value);
        }
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            DynamicContextHolder.poll();
            this.logger.debug("clean datasource");
        }
    }
}

