/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="bms.redis")
@Component
public class RedisUtils {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ValueOperations<String, String> valueOperations;
    @Autowired
    private HashOperations<String, String, Object> hashOperations;
    @Autowired
    private ListOperations<String, Object> listOperations;
    @Autowired
    private SetOperations<String, Object> setOperations;
    @Autowired
    private ZSetOperations<String, Object> zSetOperations;
    @Resource
    private ObjectMapper objectMapper;
    public static final long DEFAULT_EXPIRE = 86400L;
    public static final long NOT_EXPIRE = -1L;
    private static final Gson gson = new Gson();
    private Boolean open;

    public void set(String key, Object value, long expire) {
        this.valueOperations.set((Object)key, (Object)this.toJson(value));
        if (expire != -1L) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
        }
    }

    public void set(String key, Object value) {
        this.set(key, value, 86400L);
    }

    public <T> T get(String key, Class<T> clazz, long expire) {
        String value = (String)this.valueOperations.get((Object)key);
        if (expire != -1L) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
        }
        return (T)(value == null ? null : this.fromJson(value, clazz));
    }

    public <T> T get(String key, TypeReference<T> typeReference) {
        String value = (String)this.valueOperations.get((Object)key);
        try {
            return (T)(StringUtils.isBlank((CharSequence)value) ? null : this.objectMapper.readValue(value, typeReference));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key, clazz, -1L);
    }

    public String get(String key, long expire) {
        String value = (String)this.valueOperations.get((Object)key);
        if (expire != -1L) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
        }
        return value;
    }

    public String get(String key) {
        return this.get(key, -1L);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    private String toJson(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof String) {
            return String.valueOf(object);
        }
        return gson.toJson(object);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }
}

