/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import com.bms.common.utils.BCDCodeTool;
import com.bms.entity.Bill;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BillTool {
    private static final Logger log = LoggerFactory.getLogger(BillTool.class);
    public static final byte DEFAULT_VALUE_0 = 0;
    public static final byte DEFAULT_VALUE_1 = 1;
    public static final byte DEFAULT_VALUE_2 = 2;
    public static final byte DEFAULT_VALUE_11 = 11;
    public static final int BASE_YEAR = 2000;
    public static final byte DEFAULT_VALUE_0XFF = -1;
    public static final byte DEFAULT_VALUE_0XF = 15;
    public static final byte DEFAULT_VALUE_0X00 = 0;

    public static List<Bill> readBillFromString(String content) {
        int recordLength;
        ArrayList<Bill> bills = new ArrayList<Bill>();
        if (content == null || content.isEmpty()) {
            log.error("\u8bdd\u5355\u5185\u5bb9\u4e3a\u7a7a");
            return bills;
        }
        byte[] bytes = content.getBytes(StandardCharsets.ISO_8859_1);
        if (bytes.length % (recordLength = 240) != 0) {
            log.warn("\u8bdd\u5355\u5185\u5bb9\u957f\u5ea6\u4e0d\u662f{}\u7684\u6574\u6570\u500d: {}", (Object)recordLength, (Object)bytes.length);
        }
        int offset = 0;
        while (offset + recordLength <= bytes.length) {
            byte[] buffer = new byte[recordLength];
            System.arraycopy(bytes, offset, buffer, 0, recordLength);
            Bill bill = BillTool.parseBillFromBytes((byte[])buffer);
            if (bill != null) {
                bills.add(bill);
            }
            offset += recordLength;
        }
        log.info("\u4ece\u5b57\u7b26\u4e32\u5185\u5bb9\u4e2d\u89e3\u6790\u51fa{}\u6761\u8bdd\u5355\u8bb0\u5f55", (Object)bills.size());
        return bills;
    }

    public static List<Bill> readBillFromFile(String filePath) {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        File file = new File(filePath);
        if (!file.exists()) {
            log.error("\u8bdd\u5355\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath);
            return bills;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] buffer = new byte[240];
            while (fis.read(buffer) == 240) {
                Bill bill = BillTool.parseBillFromBytes((byte[])buffer);
                if (bill == null) continue;
                bills.add(bill);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u8bdd\u5355\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return bills;
    }

    private static Bill parseBillFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length != 240) {
            return null;
        }
        try {
            byte[] trunkBytes;
            Bill bill = new Bill();
            bill.setSerialNumber(BillTool.byteArrayToInt((byte[])bytes, (int)0));
            byte value5 = bytes[4];
            bill.setExceptionFlag((byte)((value5 & 0x80) >>> 7));
            bill.setBillType((byte)(value5 & 0x7F));
            bill.setChecksum(BillTool.byteArrayToInt((byte[])bytes, (int)5));
            byte value10 = bytes[9];
            bill.setTestCallFlag((byte)((value10 & 0x80) >>> 7));
            bill.setFreeOfChargeFlag((byte)((value10 & 0x40) >>> 6));
            bill.setClockIndication((byte)((value10 & 0x20) >>> 5));
            bill.setValidityFlag((byte)((value10 & 0x10) >>> 4));
            bill.setPartialRecordIndication((byte)(value10 & 0xF));
            byte value11 = bytes[10];
            bill.setPayer((byte)((value11 & 0xF0) >>> 4));
            bill.setPadding1((byte)((value11 & 8) >>> 3));
            bill.setCreditCardIndication((byte)((value11 & 4) >>> 2));
            bill.setCentralizedCharge((byte)((value11 & 2) >>> 1));
            bill.setChargeComplaint((byte)(value11 & 1));
            bill.setAnswerYear(bytes[11]);
            bill.setAnswerMonth(bytes[12]);
            bill.setAnswerDay(bytes[13]);
            bill.setAnswerHour(bytes[14]);
            bill.setAnswerMinute(bytes[15]);
            bill.setAnswerSecond(bytes[16]);
            bill.setReleaseYear(bytes[17]);
            bill.setReleaseMonth(bytes[18]);
            bill.setReleaseDay(bytes[19]);
            bill.setReleaseHour(bytes[20]);
            bill.setReleaseMinute(bytes[21]);
            bill.setReleaseSecond(bytes[22]);
            bill.setDuration(BillTool.byteArrayToInt((byte[])bytes, (int)23));
            bill.setCallerNumberingNetwork(bytes[27]);
            bill.setCallerAddressAttribute(bytes[28]);
            byte[] callerNumberBytes = new byte[17];
            System.arraycopy(bytes, 29, callerNumberBytes, 0, 17);
            bill.setCallerNumber(BCDCodeTool.bcd2str((byte[])callerNumberBytes));
            bill.setCalleeNumberingNetwork(bytes[46]);
            bill.setCalleeAddressAttribute(bytes[47]);
            byte[] calleeNumberBytes = new byte[17];
            System.arraycopy(bytes, 48, calleeNumberBytes, 0, 17);
            bill.setCalleeNumber(BCDCodeTool.bcd2str((byte[])calleeNumberBytes));
            if (bytes[77] != -1 || bytes[78] != -1) {
                trunkBytes = new byte[2];
                System.arraycopy(bytes, 77, trunkBytes, 0, 2);
                bill.setIncomingTrunkNumber(Integer.valueOf(BillTool.byteToChar((byte[])trunkBytes)));
            }
            if (bytes[83] != -1 || bytes[84] != -1) {
                trunkBytes = new byte[2];
                System.arraycopy(bytes, 83, trunkBytes, 0, 2);
                bill.setOutgoingTrunkNumber(Integer.valueOf(BillTool.byteToChar((byte[])trunkBytes)));
            }
            byte value90 = bytes[89];
            bill.setCalleeAccessProtocol((byte)((value90 & 0xF0) >>> 4));
            bill.setCallerAccessProtocol((byte)(value90 & 0xF));
            byte value91 = bytes[90];
            bill.setCalleeAccessSignaling((byte)((value91 & 0xF0) >>> 4));
            bill.setCallerAccessSignaling((byte)(value91 & 0xF));
            bill.setCallerType(bytes[95]);
            byte value97 = bytes[96];
            bill.setCallAttribute((byte)((value97 & 0xF0) >>> 4));
            bill.setCallType((byte)(value97 & 0xF));
            bill.setReleaseCauseValue(bytes[97]);
            byte value99 = bytes[98];
            bill.setReleaseParty((byte)((value99 & 0xF0) >>> 4));
            bill.setRoundingMode((byte)((value99 & 0xC) >>> 2));
            bill.setPadding2((byte)(value99 & 3));
            byte[] originalCalledNumberBytes = new byte[17];
            System.arraycopy(bytes, 172, originalCalledNumberBytes, 0, 17);
            bill.setOriginalCalledNumber(BCDCodeTool.bcd2str((byte[])originalCalledNumberBytes));
            return bill;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8bdd\u5355\u6570\u636e\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static int byteArrayToInt(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    public static int[] formatDateTimeInfo(Date date) {
        int[] dateInfo = new int[]{0, 0, 0, 0, 0, 0};
        if (date == null) {
            return dateInfo;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] dateTime = sdf.format(date).split(" ");
        String[] date1 = dateTime[0].split("-");
        dateInfo[0] = Integer.parseInt(date1[0]);
        dateInfo[1] = Integer.parseInt(date1[1]);
        dateInfo[2] = Integer.parseInt(date1[2]);
        String[] time = dateTime[1].split(":");
        dateInfo[3] = Integer.parseInt(time[0]);
        dateInfo[4] = Integer.parseInt(time[1]);
        dateInfo[5] = Integer.parseInt(time[2]);
        return dateInfo;
    }

    public static char byteToChar(byte[] b) {
        char c = (char)((b[1] & 0xFF) << 8 | b[0] & 0xFF);
        return c;
    }
}

