/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import org.apache.commons.lang3.StringUtils;

public class BCDCodeTool {
    public static byte[] str2bcd(String bcd) {
        try {
            if (StringUtils.isEmpty((CharSequence)bcd)) {
                return null;
            }
            int size = bcd.length() / 2;
            int remainder = bcd.length() % 2;
            byte[] bcdByte = new byte[size + remainder];
            for (int i = 0; i < size; ++i) {
                int high = Integer.parseInt(bcd.substring(2 * i, 2 * i + 1));
                int low = Integer.parseInt(bcd.substring(2 * i + 1, 2 * i + 2));
                bcdByte[i] = (byte)(high << 4 | low);
            }
            if (remainder > 0) {
                int low = Integer.parseInt(bcd.substring(bcd.length() - 1));
                bcdByte[bcdByte.length - 1] = (byte)(0xF | low << 4);
            }
            return bcdByte;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bcd2str(byte[] bcdBytes) {
        if (bcdBytes == null || bcdBytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean endFound = false;
        for (byte b : bcdBytes) {
            if (b == -1) {
                endFound = true;
                break;
            }
            int highNibble = (b & 0xF0) >>> 4;
            if (highNibble < 10) {
                sb.append(highNibble);
            } else {
                if (highNibble == 15) {
                    endFound = true;
                    break;
                }
                sb.append((char)(65 + (highNibble - 10)));
            }
            int lowNibble = b & 0xF;
            if (lowNibble < 10) {
                sb.append(lowNibble);
                continue;
            }
            if (lowNibble == 15) {
                endFound = true;
                break;
            }
            sb.append((char)(65 + (lowNibble - 10)));
        }
        String result = sb.toString();
        if (!endFound && result.length() > 4) {
            for (int i = 0; i < result.length() - 3; ++i) {
                if (!result.substring(i, i + 2).equals(result.substring(i + 2, i + 4))) continue;
                return result.substring(0, i + 2);
            }
        }
        return result;
    }
}

