/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.aspect;

import com.bms.common.annotation.SysLog;
import com.bms.common.utils.HttpContextUtils;
import com.bms.common.utils.IPUtils;
import com.bms.modules.sys.entity.SysLogEntity;
import com.bms.modules.sys.entity.SysUserEntity;
import com.bms.modules.sys.service.SysLogService;
import com.google.gson.Gson;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SysLogAspect {
    @Autowired
    private SysLogService sysLogService;

    @Pointcut(value="@annotation(com.bms.common.annotation.SysLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, time);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLogEntity sysLog = new SysLogEntity();
        SysLog syslog = method.getAnnotation(SysLog.class);
        if (syslog != null) {
            sysLog.setOperation(syslog.value());
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        sysLog.setMethod(className + "." + methodName + "()");
        Object[] args = joinPoint.getArgs();
        try {
            String params = new Gson().toJson((Object)args);
            sysLog.setParams(params);
        }
        catch (Exception params) {
            // empty catch block
        }
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        sysLog.setIp(IPUtils.getIpAddr((HttpServletRequest)request));
        String username = ((SysUserEntity)SecurityUtils.getSubject().getPrincipal()).getUsername();
        sysLog.setUsername(username);
        sysLog.setTime(Long.valueOf(time));
        sysLog.setCreateDate(Date.from(Instant.now()));
        this.sysLogService.save((Object)sysLog);
    }
}

